#exec OBJ LOAD FILE=XGameShaders.utx
#exec OBJ LOAD FILE=Crosshairs.utx
#EXEC OBJ LOAD FILE=LastManStanding.utx

class HudBDeathMatch extends HudBase
    config(User);

var() DigitSet DigitsBig;

var() SpriteWidget LHud1[4];
var() SpriteWidget LHud2[4];

var() SpriteWidget RHud1[4];
var() SpriteWidget RHud2[4];

const WEAPON_BAR_SIZE = 9;

var() SpriteWidget WeaponBarAmmoFill[WEAPON_BAR_SIZE];
var() SpriteWidget WeaponBarTint[WEAPON_BAR_SIZE];
var() SpriteWidget WeaponBarTrim[WEAPON_BAR_SIZE];
var() SpriteWidget WeaponBarIcon[WEAPON_BAR_SIZE];
var() class<Weapon> BaseWeapons[WEAPON_BAR_SIZE];

var() SpriteWidget AmmoIcon;

var() SpriteWidget ScoreBg[4];
var() SpriteWidget Adrenaline[5];

var() SpriteWidget  HealthIcon;

var() NumericWidget AdrenalineCount;
var() NumericWidget ComboCount;
var() NumericWidget HealthCount;
var() NumericWidget AmmoCount;
var() NumericWidget ShieldCount;
var() NumericWidget mySpread;
var() NumericWidget myRank;
var() NumericWidget myScore;

var() SpriteWidget ShieldIconGlow;
var() SpriteWidget ShieldIcon;
var() SpriteWidget AdrenalineIcon;
var() SpriteWidget ReloadingTeamTint;
var() SpriteWidget ReloadingTrim;
var() SpriteWidget ReloadingFill;

var() SpriteWidget UDamageTeamTint;
var() SpriteWidget UDamageTrim;
var() SpriteWidget UDamageFill;

var() Font LevelActionFontFont;
var() Color LevelActionFontColor;

var() float LevelActionPositionX, LevelActionPositionY;
var() float CurrentWeaponPositionX, CurrentWeaponPositionY;

var() Texture LogoTexture;

var() float LogoScaleX;
var() float LogoScaleY;
var() float LogoPosX;
var() float LogoPosY;

var() float testLerp;

var() float comboTime;
var() float accumData[4];
var() float growScale[4];
var() float growTrace[4];
var() int   pulse[5];

var() bool ArmorGlow;
var() bool Displaying;
var() bool growing;
var() bool LowHealthPulse;
var() bool TeamLinked;
var() bool AdrenalineReady;
var bool bRealSmallWeaponBar;

var float OldHUDScale;

var() float TransRechargeAmount;

var transient float CurHealth, LastHealth, CurShield, LastShield, CurEnergy, CurAmmoPrimary, pulseHealthIcon,pulseArmorIcon;
var transient float MaxShield, MaxEnergy, MaxAmmoPrimary;

var transient int CurScore, CurRank, ScoreDiff;

var int OldRemainingTime;
var sound CountDown[10];
var sound LongCount[6];

var PlayerReplicationInfo NamedPlayer;
var float NameTime;

var Material Portrait;
var float PortraitTime;
var float PortraitX;

var array<SceneManager> MySceneManagers;

simulated function UpdatePrecacheMaterials()
{
    Level.AddPrecacheMaterial(Material'InterfaceContent.HUD.SkinA');
    Level.AddPrecacheMaterial(Material'XGameShaders.ScreenNoise');
    Level.AddPrecacheMaterial(Material'InterfaceContent.BorderBoxA1');
}

function PostBeginPlay()
{
	local SceneManager SM;

	Super.PostBeginPlay();

    foreach AllActors(class'SceneManager',SM)
    {
    	MySceneManagers.Length = MySceneManagers.Length+1;
    	MySceneManagers[MySceneManagers.Length-1] = SM;
    }

	if ( CustomCrosshairsAllowed() )
		SetCustomCrosshairs();
}

function bool CustomCrosshairsAllowed()
{
	return true;
}

function bool CustomCrosshairColorAllowed()
{
	return true;
}

function bool CustomHUDColorAllowed()
{
	return true;
}

// TODO Add support for custom crosshair scale to menus
function SetCustomCrosshairs()
{
	local int i;
	local array<CacheManager.CrosshairRecord> CustomCrosshairs;

	class'CacheManager'.static.GetCrosshairList(CustomCrosshairs);
	Crosshairs.Length = CustomCrosshairs.Length;
	for (i = 0; i < CustomCrosshairs.Length; i++)
	{
		Crosshairs[i].WidgetTexture = CustomCrosshairs[i].CrosshairTexture;

		Crosshairs[i].TextureCoords.X1 = 0;
		Crosshairs[i].TextureCoords.X2 = 64;
		Crosshairs[i].TextureCoords.Y1 = 0;
		Crosshairs[i].TextureCoords.Y2 = 64;

		Crosshairs[i].TextureScale = 0.75;
		Crosshairs[i].DrawPivot = DP_MiddleMiddle;
		Crosshairs[i].PosX = 0.5;
		Crosshairs[i].PosY = 0.5;
		Crosshairs[i].OffsetX = 0;
		Crosshairs[i].OffsetY = 0;
		Crosshairs[i].ScaleMode = SM_None;
		Crosshairs[i].Scale = 1.0;
		Crosshairs[i].RenderStyle = STY_Alpha;
	}

	if ( CustomCrosshairColorAllowed() )
		SetCustomCrosshairColors();
}

function SetCustomCrosshairColors()
{
	local int i, j;

	for (i = 0; i < Crosshairs.Length; i++)
		for (j = 0; j < 2; j++)
			Crosshairs[i].Tints[j] = CrosshairColor;
}

function SetCustomHUDColor()
{
	local int i,j;

	if ( (CustomHUDColor.R == 0) && (CustomHUDColor.G == 0) && (CustomHUDColor.B == 0) && (CustomHUDColor.A == 0) )
		return;

	bUsingCustomHUDColor = true;
	for ( j=0; j<2; j++ )
	{
		ReloadingTeamTint.Tints[j] = CustomHUDColor;
		UDamageTeamTint.Tints[j] = CustomHUDColor;
		for ( i=1; i<3; i++ )
		{
			LHUD1[i].Tints[j] = CustomHUDColor;
			LHUD2[i].Tints[j] = CustomHUDColor;
			RHUD1[i].Tints[j] = CustomHUDColor;
			RHUD2[i].Tints[j] = CustomHUDColor;
			Adrenaline[i].Tints[j] = CustomHUDColor;
			ScoreBg[i].Tints[j] = CustomHUDColor;
		}
		for ( i=0; i<9; i++ )
			WeaponBarTint[i].Tints[j] = CustomHUDColor;
	}
}


function CheckCountdown(GameReplicationInfo GRI)
{
	if ( (GRI == None) || (GRI.RemainingTime == 0) || (GRI.RemainingTime == OldRemainingTime) || (GRI.Winner != None) )
		return;

	OldRemainingTime = GRI.RemainingTime;
	if ( OldRemainingTime > 300 )
		return;
	if ( OldRemainingTime > 30 )
	{
		if ( OldRemainingTime == 300 )
			PlayerOwner.PlayAnnouncement(LongCount[0],1,true);
		else if ( OldRemainingTime == 180 )
			PlayerOwner.PlayAnnouncement(LongCount[1],1,true);
		else if ( OldRemainingTime == 120 )
			PlayerOwner.PlayAnnouncement(LongCount[2],1,true);
		else if ( OldRemainingTime == 60 )
			PlayerOwner.PlayAnnouncement(LongCount[3],1,true);
		return;
	}
	if ( OldRemainingTime == 30 )
		PlayerOwner.PlayAnnouncement(LongCount[4],1,true);
	else if ( OldRemainingTime == 20 )
		PlayerOwner.PlayAnnouncement(LongCount[5],1,true);
	else if ( (OldRemainingTime <= 10) && (OldRemainingTime > 0) )
		PlayerOwner.PlayAnnouncement(CountDown[OldRemainingTime - 1],1,true);
}

simulated function Tick(float deltaTime)
{
	local Material NewPortrait;

    Super.Tick(deltaTime);

	if ( (Level.TimeSeconds - LastPlayerIDTalkingTime < 0.1) && (PlayerOwner.GameReplicationInfo != None) )
	{
		if ( (PortraitPRI == None) || (PortraitPRI.PlayerID != LastPlayerIDTalking) )
		{
			PortraitPRI = PlayerOwner.GameReplicationInfo.FindPlayerByID(LastPlayerIDTalking);
			if ( PortraitPRI != None )
			{
				NewPortrait = PortraitPRI.GetPortrait();
				if ( NewPortrait != None )
				{
					if ( Portrait == None )
						PortraitX = 1;
					Portrait = NewPortrait;
					PortraitTime = Level.TimeSeconds + 3;
				}
			}
		}
		else
			PortraitTime = Level.TimeSeconds + 0.2;
	}
	else
		LastPlayerIDTalking = 0;

	if ( PortraitTime - Level.TimeSeconds > 0 )
		PortraitX = FMax(0,PortraitX-3*deltaTime);
	else if ( Portrait != None )
	{
		PortraitX = FMin(1,PortraitX+3*deltaTime);
		if ( PortraitX == 1 )
		{
			Portrait = None;
			PortraitPRI = None;
		}
	}

    pulseNumber(0, HealthCount, 0.26, 0.05, deltaTime, 0.25, 0,255,CurHealth, LastHealth);
    pulseNumber(1, ShieldCount, 0.26, 0.05, deltaTime, 0.25, 0,255,CurShield, LastShield);

    ArmorPulse(deltaTime,255,0,ShieldIconGlow,TeamIndex,250);
    if(CurHealth < 50)
        LowHealth(deltaTime,255,0,LHud2[3],TeamIndex,1000);
    else
        LHud2[3].Tints[TeamIndex].A = 50;

    if(CurHealth < 25)
        pulseWidget(deltaTime, 255, 0, HealthIcon, TeamIndex, 2, 2000);
    else
        HealthIcon.Tints[TeamIndex].A = 255;

    if(AdrenalineReady)
        pulseWidget(deltaTime, 255, 0, Adrenaline[4], TeamIndex, 2, 1000);
    else
        Adrenaline[4].Tints[TeamIndex].A = 0;
}

simulated function pulseWidget(float deltaTime, float max, float min, out SpriteWidget sprite, int tIndex, int pIndex, float pRate)
{
    local float accum;

    accum = deltaTime * pRate;

    if(sprite.Tints[tIndex].A < min)
        accumData[pIndex] += accum;
    else
        accumData[pIndex] -= accum;

    if(accumData[pIndex] < min)
        accumData[pIndex] = max;

    sprite.Tints[tIndex].A = accumData[pIndex];
}

simulated function pulseNumber(int gIndex, out NumericWidget number, float nScale, float growSpeed, float deltaTime, float oScale ,float test1,float test2, float first, float last)
{
    local float growAccum;

    growAccum = deltaTime * growSpeed;

    testLerp = test1 + (deltaTime * 2) *(test2 - test1);

    if(growing)
    {
        growScale[gIndex] -= growAccum;
        growTrace[gIndex] += testLerp;

        if(growTrace[gIndex] > 255)
            growTrace[gIndex] = 255;

        if (first < last)
        {
            growTrace[gIndex] = 0;
            growScale[gIndex] = nScale;
        }
        if(growScale[gIndex] < oScale)
            growScale[gIndex] = oScale;

        if(growScale[gIndex] < oScale && growTrace[gIndex] ==255)
            growing = false;

        number.Tints[TeamIndex].B = growTrace[gIndex];
        number.TextureScale = growScale[gIndex];
    }
    else if (first < last)
    {
        growTrace[gIndex] = 0;
        growScale[gIndex] = nScale;
        growing = true;
    }
    else
    {
        growScale[gIndex] = oScale;
    }
}


simulated function ArmorPulse(float deltaTime, float max, float min, out SpriteWidget sprite, int tIndex, float pRate)
{
    local int accum;

    accum = deltaTime * pRate;

    if(ArmorGlow)
        pulseArmorIcon += accum;
    else
        pulseArmorIcon -= accum;

    if(pulseArmorIcon<= min)
    {
        pulseArmorIcon= min;
        ArmorGlow = true;
    }
    else if(pulseArmorIcon >= max)
    {
        pulseArmorIcon= max;
        ArmorGlow = false;
    }

    sprite.Tints[tIndex].A = pulseArmorIcon;
    sprite.Tints[tIndex].B = pulseArmorIcon;

}
simulated function LowHealth(float deltaTime, float max, float min, out SpriteWidget sprite, int tIndex,float pRate)
{
    local int accum;

    accum = deltaTime * pRate;

    if(LowHealthPulse)
        pulseHealthIcon += accum;
    else
        pulseHealthIcon -= accum;

    if(pulseHealthIcon<= min)
    {
        pulseHealthIcon= min;
        LowHealthPulse = true;
    }
    else if(pulseHealthIcon >= max)
    {
        pulseHealthIcon= max;
        LowHealthPulse = false;
    }
    sprite.Tints[tIndex].A = pulseHealthIcon;
}

//////////////////////////////////////////
simulated function UpdateRankAndSpread(Canvas C)
{
    local int i;

	if ( (Scoreboard == None) || !Scoreboard.UpdateGRI() )
		return;

    for( i=0 ; i<PlayerOwner.GameReplicationInfo.PRIArray.Length ; i++ )
         if(PawnOwnerPRI == PlayerOwner.GameReplicationInfo.PRIArray[i])
         {
            myRank.Value = (i+1);
            break;
         }

	myScore.Value = Min (PawnOwnerPRI.Score, 999);  // max display space
	if ( PawnOwnerPRI == PlayerOwner.GameReplicationInfo.PRIArray[0] )
	{
		if ( PlayerOwner.GameReplicationInfo.PRIArray.Length > 1 )
			mySpread.Value = Min (PawnOwnerPRI.Score - PlayerOwner.GameReplicationInfo.PRIArray[1].Score, 999);
		else
			mySpread.Value = 0;
	}
	else
		mySpread.Value = Min (PawnOwnerPRI.Score - PlayerOwner.GameReplicationInfo.PRIArray[0].Score, 999);

    if( bShowPoints )
    {
        DrawNumericWidget (C, myScore, DigitsBig);
        if ( C.ClipX >= 640 )
			DrawNumericWidget (C, mySpread, DigitsBig);
        DrawNumericWidget (C, myRank, DigitsBig);
    }

    if(myRank.Value > 9)
    {
        myRank.TextureScale = 0.12;
        myRank.OffsetX = 240;
        myRank.OffsetY = 90;
    }
    else
    {
        myRank.TextureScale = 0.18;
        myRank.OffsetX = 150;
        myRank.OffsetY = 40;
    }
}

simulated function CalculateHealth()
{
    LastHealth = CurHealth;
    CurHealth = PawnOwner.Health;
}

simulated function CalculateShield()
{
    LastShield = CurShield;
    if( PawnOwner.IsA ('XPawn') )
    {
        MaxShield = XPawn(PawnOwner).ShieldStrengthMax;
        CurShield = Clamp (XPawn(PawnOwner).ShieldStrength, 0, MaxShield);
    }
    else
    {
        MaxShield = 100;
        CurShield = 0;
    }
}

simulated function CalculateEnergy()
{
	if ( PawnOwner.Controller == None )
	{
		MaxEnergy = PlayerOwner.AdrenalineMax;
		CurEnergy = Clamp (PlayerOwner.Adrenaline, 0, MaxEnergy);
	}
	else
	{
		MaxEnergy = PawnOwner.Controller.AdrenalineMax;
		CurEnergy = Clamp (PawnOwner.Controller.Adrenaline, 0, MaxEnergy);
	}
    AdrenalineCount.Value = CurEnergy;
}

simulated function CalculateAmmo()
{
    MaxAmmoPrimary = 1;
    CurAmmoPrimary = 1;

    if ( (PawnOwner != none) && (PawnOwner.Weapon != none) )
		PawnOwner.Weapon.GetAmmoCount(MaxAmmoPrimary,CurAmmoPrimary);
}

simulated function CalculateScore()
{
    ScoreDiff = CurScore;
    CurScore = PawnOwnerPRI.Score;
}

simulated function string GetScoreText()
{
	return ScoreText;
}

simulated function string GetScoreValue(PlayerReplicationInfo PRI)
{
	return ""$int(PRI.Score);
}

simulated function string GetScoreTagLine()
{
	return InitialViewingString;
}

simulated function DrawSpectatingHud (Canvas C)
{
	local string InfoString;
    local plane OldModulate;
    local float xl,yl,Full, Height, Top, TextTop, MedH, SmallH,Scale;
    local GameReplicationInfo GRI;
    local int i;

    DisplayLocalMessages (C);

	// Hack for tutorials.

	if (MySceneManagers.Length>0)
    {
    	for (i=0;i<MySceneManagers.Length;i++)
        	if (MySceneManagers[i].bIsRunning)
				return;
    }

    OldModulate = C.ColorModulate;

    C.Font = GetMediumFontFor(C);
    C.StrLen("W",xl,MedH);
	Height = MedH;
	C.Font = GetConsoleFont(C);
    C.StrLen("W",xl,SmallH);
    Height += SmallH;

	Full = Height;
    Top  = C.ClipY-8-Full;

	Scale = (Full+16)/128;

	// I like Yellow

    C.ColorModulate.X=255;
    C.ColorModulate.Y=255;
    C.ColorModulate.Z=0;
    C.ColorModulate.W=255;

	// Draw Border

	C.SetPos(0,Top);
    C.SetDrawColor(255,255,255,255);
    C.DrawTileStretched(material'InterfaceContent.SquareBoxA',C.ClipX,Full);
    C.ColorModulate.Z=255;

    TextTop = Top + 4;
    GRI = PlayerOwner.GameReplicationInfo;

    C.SetPos(0,Top-8);
    C.Style=5;
    C.DrawTile(material'LMSLogoSmall',256*Scale,128*Scale,0,0,256,128);
    C.Style=1;

	if ( UnrealPlayer(Owner).bDisplayWinner ||  UnrealPlayer(Owner).bDisplayLoser )
	{
		if ( UnrealPlayer(Owner).bDisplayWinner )
			InfoString = YouveWonTheMatch;
		else
		{
			if ( PlayerReplicationInfo(PlayerOwner.GameReplicationInfo.Winner) != None )
				InfoString = WonMatchPrefix$PlayerReplicationInfo(PlayerOwner.GameReplicationInfo.Winner).PlayerName$WonMatchPostFix;
			else
				InfoString = YouveLostTheMatch;
		}

        C.SetDrawColor(255,255,255,255);
        C.Font = GetMediumFontFor(C);
        C.StrLen(InfoString,XL,YL);
        C.SetPos( (C.ClipX/2) - (XL/2), Top + (Full/2) - (YL/2));
        C.DrawText(InfoString,false);
    }

	else if ( Pawn(PlayerOwner.ViewTarget) != None && Pawn(PlayerOwner.ViewTarget).PlayerReplicationInfo != None )
    {
    	// Draw View Target info

		C.SetDrawColor(32,255,32,255);

		if ( C.ClipX < 640 )
			SmallH = 0;
		else
		{
			// Draw "Now Viewing"

			C.SetPos((256*Scale*0.75),TextTop);
			C.DrawText(NowViewing,false);

    		// Draw "Score"

			InfoString = GetScoreText();
			C.StrLen(InfoString,Xl,Yl);
			C.SetPos(C.ClipX-5-XL,TextTop);
			C.DrawText(InfoString);
		}

        // Draw Player Name

        C.SetDrawColor(255,255,0,255);
        C.Font = GetMediumFontFor(C);
        C.SetPos((256*Scale*0.75),TextTop+SmallH);
        C.DrawText(Pawn(PlayerOwner.ViewTarget).PlayerReplicationInfo.PlayerName,false);

        // Draw Score

	    InfoString = GetScoreValue(Pawn(PlayerOwner.ViewTarget).PlayerReplicationInfo);
	    C.StrLen(InfoString,xl,yl);
	    C.SetPos(C.ClipX-5-XL,TextTop+SmallH);
	    C.DrawText(InfoString,false);

        // Draw Tag Line

	    C.Font = GetConsoleFont(C);
	    InfoString = GetScoreTagLine();
	    C.StrLen(InfoString,xl,yl);
	    C.SetPos( (C.ClipX/2) - (XL/2),Top-3-YL);
	    C.DrawText(InfoString);
    }
    else
    {
		InfoString = GetInfoString();

    	// Draw
    	C.SetDrawColor(255,255,255,255);
        C.Font = GetMediumFontFor(C);
        C.StrLen(InfoString,XL,YL);
        C.SetPos( (C.ClipX/2) - (XL/2), Top + (Full/2) - (YL/2));
        C.DrawText(InfoString,false);
    }

    C.ColorModulate = OldModulate;

}

simulated function String GetInfoString()
{
	local string InfoString;

	if ( PlayerOwner.IsDead() )
	{
	    if ( PlayerOwner.PlayerReplicationInfo.bOutOfLives )
	        InfoString = class'ScoreboardDeathMatch'.default.OutFireText;
	    else if ( Level.TimeSeconds - UnrealPlayer(PlayerOwner).LastKickWarningTime < 2 )
    		InfoString = class'GameMessage'.Default.KickWarning;
	    else
	        InfoString = class'ScoreboardDeathMatch'.default.Restart;
	}
	else if ( Level.TimeSeconds - UnrealPlayer(PlayerOwner).LastKickWarningTime < 2 )
    	InfoString = class'GameMessage'.Default.KickWarning;
    else if ( GUIController(PlayerOwner.Player.GUIController).ActivePage!=None)
    	InfoString = AtMenus;
	else if ( (PlayerOwner.PlayerReplicationInfo != None) && PlayerOwner.PlayerReplicationInfo.bWaitingPlayer )
	    InfoString = WaitingToSpawn;
    else
		InfoString = InitialViewingString;

	return InfoString;
}

// ====================

simulated function DrawCrosshair (Canvas C)
{
    local float NormalScale;
    local int i, CurrentCrosshair;
    local float OldScale,OldW, CurrentCrosshairScale;
    local color CurrentCrosshairColor;
	local SpriteWidget CHtexture;

    if (!bCrosshairShow)
        return;

	if ( bUseCustomWeaponCrosshairs && (PawnOwner != None) && (PawnOwner.Weapon != None) )
	{
		CurrentCrosshair = PawnOwner.Weapon.CustomCrosshair;
		if (CurrentCrosshair == -1 || CurrentCrosshair == Crosshairs.Length)
		{
//			log("Not drawing crosshair because it's -1 or "$Crosshairs.Length);
			DrawEnemyName(C);
			return;
		}

		CurrentCrosshairColor = PawnOwner.Weapon.CustomCrosshairColor;
		CurrentCrosshairScale = PawnOwner.Weapon.CustomCrosshairScale;
		if ( PawnOwner.Weapon.CustomCrosshairTextureName != "" )
		{
			if ( PawnOwner.Weapon.CustomCrosshairTexture == None )
			{
				PawnOwner.Weapon.CustomCrosshairTexture = Texture(DynamicLoadObject(PawnOwner.Weapon.CustomCrosshairTextureName,class'Texture'));
				if ( PawnOwner.Weapon.CustomCrosshairTexture == None )
				{
					log(PawnOwner.Weapon$" custom crosshair texture not found!");
					PawnOwner.Weapon.CustomCrosshairTextureName = "";
				}
			}
			CHTexture = Crosshairs[0];
			CHTexture.WidgetTexture = PawnOwner.Weapon.CustomCrosshairTexture;
		}
	}
	else
	{
		CurrentCrosshair = CrosshairStyle;
		CurrentCrosshairColor = CrosshairColor;
		CurrentCrosshairScale = CrosshairScale;
	}

	CurrentCrosshair = Clamp(CurrentCrosshair, 0, Crosshairs.Length - 1);

    NormalScale = Crosshairs[CurrentCrosshair].TextureScale;
	if ( CHTexture.WidgetTexture == None )
		CHTexture = Crosshairs[CurrentCrosshair];
    CHTexture.TextureScale *= CurrentCrosshairScale;

    for( i = 0; i < ArrayCount(CHTexture.Tints); i++ )
        CHTexture.Tints[i] = CurrentCrossHairColor;

	if ( LastPickupTime > Level.TimeSeconds - 0.4 )
	{
		if ( LastPickupTime > Level.TimeSeconds - 0.2 )
			CHTexture.TextureScale *= (1 + 5 * (Level.TimeSeconds - LastPickupTime));
		else
			CHTexture.TextureScale *= (1 + 5 * (LastPickupTime + 0.4 - Level.TimeSeconds));
	}
    OldScale = HudScale;
    HudScale=1;
    OldW = C.ColorModulate.W;
    C.ColorModulate.W = 1;
    DrawSpriteWidget (C, CHTexture);
    C.ColorModulate.W = OldW;
	HudScale=OldScale;
    CHTexture.TextureScale = NormalScale;

	DrawEnemyName(C);
}

function DrawEnemyName(Canvas C)
{
	local actor HitActor;
	local vector HitLocation,HitNormal,ViewPos;

	if ( PlayerOwner.bBehindView || bNoEnemyNames || (PawnOwner.Controller == None) )
		return;
	ViewPos = PawnOwner.Location + PawnOwner.BaseEyeHeight * vect(0,0,1);
	HitActor = trace(HitLocation,HitNormal,ViewPos+1200*vector(PawnOwner.Controller.Rotation),ViewPos,true);
	if ( (Pawn(HitActor) != None) && (Pawn(HitActor).PlayerReplicationInfo != None)
		&& (HitActor != PawnOwner)
		&& ( (PawnOwner.PlayerReplicationInfo.Team == None) || (PawnOwner.PlayerReplicationInfo.Team != Pawn(HitActor).PlayerReplicationInfo.Team)) )
	{
		if ( (NamedPlayer != Pawn(HitActor).PlayerReplicationInfo) || (Level.TimeSeconds - NameTime > 0.5) )
		{
			DisplayEnemyName(C, Pawn(HitActor).PlayerReplicationInfo);
			NameTime = Level.TimeSeconds;
		}
		NamedPlayer = Pawn(HitActor).PlayerReplicationInfo;
	}
}

function DisplayEnemyName(Canvas C, PlayerReplicationInfo PRI)
{
	PlayerOwner.ReceiveLocalizedMessage(class'PlayerNameMessage',0,PRI);
}

function SetSmallWeaponBar()
{
	local int i;

	bRealSmallWeaponBar = bSmallWeaponBar;

	if ( bSmallWeaponBar )
	{
		LHud1[0].TextureCoords.Y2 = 893;
		LHud1[1].TextureCoords.Y2 = 893;
		LHud1[0].PosY = 0.89;
		LHud1[1].PosY = 0.89;
		LHud1[0].TextureScale = 0.25;
		LHud1[1].TextureScale = 0.25;

		LHud2[1].PosY = 0.88;
		LHud2[0].PosY = 0.88;
		LHud1[3].PosY = 0.88;
		LHud2[3].PosY = 0.88;
		HealthIcon.PosY = 0.88;
		HealthCount.PosY = 0.88;

		LHud2[1].PosX = -0.03;
		LHud2[0].PosX = -0.03;
		LHud1[3].PosX = -0.03;
		LHud2[3].PosX = -0.03;
		HealthIcon.PosX = -0.03;
		HealthCount.PosX = -0.03;


		UDamageTrim.TextureScale = 0.27;
		UDamageTeamTint.TextureScale = 0.27;
		UDamageFill.TextureScale = 0.27;

		UDamageTrim.PosX = -0.005;
		UDamageTeamTint.PosX = -0.005;
		UDamageFill.PosX = -0.005;

		UDamageTrim.PosY = 0.88;
		UDamageTeamTint.PosY = 0.88;
		UDamageFill.PosY = 0.88;

		RHud1[0].TextureCoords.Y2 = 893;
		RHud1[1].TextureCoords.Y2 = 893;
		RHud1[0].PosY = 0.89;
		RHud1[1].PosY = 0.89;
		RHud1[0].TextureScale = 0.25;
		RHud1[1].TextureScale = 0.25;

		RHud2[1].PosY = 0.88;
		RHud2[0].PosY = 0.88;
		RHud1[3].PosY = 0.88;
		RHud2[3].PosY = 0.88;
		AmmoIcon.PosY = 0.88;
		AmmoCount.PosY = 0.88;

		RHud2[1].PosX = 1.03;
		RHud2[0].PosX = 1.03;
		RHud1[3].PosX = 1.03;
		RHud2[3].PosX = 1.03;
		AmmoIcon.PosX = 1.03;
		AmmoCount.PosX = 1.03;

		ReloadingTrim.TextureScale = 0.27;
		ReloadingTeamTint.TextureScale = 0.27;
		ReloadingFill.TextureScale = 0.27;

		ReloadingTrim.PosX = 1.005;
		ReloadingTeamTint.PosX = 1.005;
		ReloadingFill.PosX = 1.005;

		ReloadingTrim.PosY = 0.88;
		ReloadingTeamTint.PosY = 0.88;
		ReloadingFill.PosY = 0.88;
	}
	else
	{
		// reset to defaults
		for ( i=0; i<4; i++ )
		{
			LHUD1[i].PosX = Default.LHUD1[i].PosX;
			LHUD1[i].PosY = Default.LHUD1[i].PosY;

			LHUD2[i].PosX = Default.LHUD2[i].PosX;
			LHUD2[i].PosY = Default.LHUD2[i].PosY;

			RHUD1[i].PosX = Default.RHUD1[i].PosX;
			RHUD1[i].PosY = Default.RHUD1[i].PosY;

			RHUD2[i].PosX = Default.RHUD2[i].PosX;
			RHUD2[i].PosY = Default.RHUD2[i].PosY;

			ShieldCount.PosY = Default.ShieldCount.PosY;
			ShieldIcon.PosY = Default.ShieldIcon.PosY;
			ShieldIconGlow.PosY = Default.ShieldIconGlow.PosY;
		}
		LHUD1[0].TextureScale = Default.LHUD1[0].TextureScale;
		LHud1[0].TextureCoords = Default.LHud1[0].TextureCoords;
		RHUD1[0].TextureScale = Default.RHUD1[0].TextureScale;
		RHUD1[0].TextureCoords = Default.RHud1[0].TextureCoords;

		LHUD1[1].TextureScale = Default.LHUD1[1].TextureScale;
		LHud1[1].TextureCoords = Default.LHud1[1].TextureCoords;
		RHUD1[1].TextureScale = Default.RHUD1[1].TextureScale;
		RHUD1[1].TextureCoords = Default.RHud1[1].TextureCoords;

		HealthIcon.PosY = Default.HealthIcon.PosY;
		HealthCount.PosY = Default.HealthCount.PosY;
		HealthIcon.PosX = Default.HealthIcon.PosX;
		HealthCount.PosX = Default.HealthCount.PosX;

		UDamageTrim.TextureScale = Default.UDamageTrim.TextureScale;
		UDamageTeamTint.TextureScale = Default.UDamageTeamTint.TextureScale;
		UDamageFill.TextureScale = Default.UDamageFill.TextureScale;

		UDamageTrim.PosX = Default.UDamageTrim.PosX;
		UDamageTeamTint.PosX = Default.UDamageTeamTint.PosX;
		UDamageFill.PosX = Default.UDamageFill.PosX;

		UDamageTrim.PosY = Default.UDamageTrim.PosY;
		UDamageTeamTint.PosY = Default.UDamageTeamTint.PosY;
		UDamageFill.PosY = Default.UDamageFill.PosY;

		AmmoIcon.PosY = Default.AmmoIcon.PosY;
		AmmoCount.PosY = Default.AmmoCount.PosY;

		AmmoIcon.PosX = Default.AmmoIcon.PosX;
		AmmoCount.PosX = Default.AmmoCount.PosX;

		ReloadingTrim.TextureScale = Default.ReloadingTrim.TextureScale;
		ReloadingTeamTint.TextureScale = Default.ReloadingTeamTint.TextureScale;
		ReloadingFill.TextureScale = Default.ReloadingFill.TextureScale;

		ReloadingTrim.PosX = Default.ReloadingTrim.PosX;
		ReloadingTeamTint.PosX = Default.ReloadingTeamTint.PosX;
		ReloadingFill.PosX = Default.ReloadingFill.PosX;

		ReloadingTrim.PosY = Default.ReloadingTrim.PosY;
		ReloadingTeamTint.PosY = Default.ReloadingTeamTint.PosY;
		ReloadingFill.PosY = Default.ReloadingFill.PosY;
	}
	SetHUDScale();
}

function SetHUDScale()
{
	local int i;
	local float NewPosX,NewPosY;

	OldHUDScale = HUDScale;

	if ( bSmallWeaponBar )
	{
		HudScale *= 0.67;
		NewPosY = Default.WeaponBarTint[0].PosY + (1 - HUDScale) * 0.043;
	}
	else
		NewPosY = Default.WeaponBarTint[0].PosY;

 //    for( i=0; i<WEAPON_BAR_SIZE; i++ )
	// {
	// 	NewPosX = 0.5 * (1 - HUDScale) + HUDScale * Default.WeaponBarAmmoFill[i].PosX;
	// 	WeaponBarAmmoFill[i].PosX = newPosX;
	// 	WeaponBarTint[i].PosX = newPosX;
	// 	WeaponBarTrim[i].PosX = newPosX;
	// 	WeaponBarIcon[i].PosX = newPosX;
	// 	WeaponBarAmmoFill[i].PosY = NewPosY + 0.043 * HUDScale;
	// 	WeaponBarTint[i].PosY = NewPosY;
	// 	WeaponBarTrim[i].PosY = NewPosY;
	// 	WeaponBarIcon[i].PosY = NewPosY;
	// }

	HUDScale = OldHUDScale;
}

function DisplayVoiceGain(Canvas C)
{
	local Texture Tex;
	local float VoiceGain;
	local float PosY, BlockSize;
	local int i;

	BlockSize = 8192/C.ClipX * HUDScale;
	Tex = Texture'engine.WhiteSquareTexture';
	PosY = C.ClipY * 0.375;
	VoiceGain = (1 - 3 * Min( Level.TimeSeconds - LastVoiceGainTime, 0.3333 )) * LastVoiceGain;

	for( i=0; i<10; i++ )
	{
		if( VoiceGain > (0.1 * i) )
		{
			C.SetPos( 0.5 * BlockSize, PosY );
			C.SetDrawColor( 28.3 * i, 255 - 28.3 * i, 0, 255 );
			C.DrawTile( Tex, BlockSize, BlockSize, 0, 0, Tex.USize, Tex.VSize );
			PosY -= 1.2 * BlockSize;
		}
	}
}

// Alpha Pass ==================================================================================
simulated function DrawHudPassA (Canvas C)
{
	local class<Ammunition> AmmoClass;

    ShowPointBarBottom(C);

	if ( bSmallWeaponBar != bRealSmallWeaponBar )
		SetSmallWeaponBar();
	if ( HUDScale != OldHUDScale )
		SetHUDScale();
    if( bShowPersonalInfo )
    {
        DrawSpriteWidget (C, LHud1[1]);
        DrawSpriteWidget (C, LHud2[1]);

        DrawSpriteWidget (C, Adrenaline[1] );
        DrawSpriteWidget (C, LHud1[0]);
        DrawSpriteWidget (C, LHud2[0]);
        DrawSpriteWidget (C, LHud1[3]);
        DrawSpriteWidget (C, LHud2[3]);
   }

	if ( bShowWeaponBar && (PawnOwner.Weapon != None) )
        DrawWeaponBar(C);

    if( bShowWeaponInfo && (PawnOwner.Weapon != None) )
    {
        DrawSpriteWidget (C, RHud1[1]);
        DrawSpriteWidget (C, RHud2[1]);

        DrawSpriteWidget (C, RHud1[0]);
        DrawSpriteWidget (C, RHud2[0]);

        DrawSpriteWidget (C, RHud1[3]);
        DrawSpriteWidget (C, RHud2[3]);

        if ( PawnOwner.Weapon.bShowChargingBar )
        {
            ReloadingFill.Scale = PawnOwner.Weapon.ChargeBar();

            DrawSpriteWidget (C, ReloadingFill);
            DrawSpriteWidget (C, ReloadingTeamTint);
            DrawSpriteWidget (C, ReloadingTrim);
        }

		AmmoClass = PawnOwner.Weapon.GetAmmoClass(0);
        if( (AmmoClass != None) && (AmmoClass.Default.IconMaterial != None) )
        {
            AmmoIcon.WidgetTexture = AmmoClass.Default.IconMaterial;
            AmmoIcon.TextureCoords = AmmoClass.Default.IconCoords;
            DrawSpriteWidget (C, AmmoIcon);
        }
    }

    if( bShowPersonalInfo && (ShieldCount.Value > 0) )
        DrawSpriteWidget (C, ShieldIconGlow);

	if( Level.TimeSeconds - LastVoiceGainTime < 0.333 )
		DisplayVoiceGain(C);

}

simulated function ShowPointBarTop(Canvas C)
{
    if( bShowPoints )
    {
        DrawSpriteWidget (C, ScoreBG[0]);
        DrawSpriteWidget (C, ScoreBG[3]);
    }
}
simulated function ShowPointBarBottom(Canvas C)
{
    if( bShowPoints )
    {
        DrawSpriteWidget (C, ScoreBG[2]);
        DrawSpriteWidget (C, ScoreBG[1]);
    }
}

// Alpha Pass ==================================================================================
simulated function DrawHudPassC (Canvas C)
{
	local float PortraitWidth,PortraitHeight, XL, YL, Abbrev, SmallH, NameWidth;
	local string PortraitString;

	// portrait
	if ( bShowPortrait && (Portrait != None) )
	{
		PortraitWidth = 0.125 * C.ClipY;
		PortraitHeight = 1.5 * PortraitWidth;
		C.DrawColor = WhiteColor;

		C.SetPos(-PortraitWidth*PortraitX + 0.025*PortraitWidth,0.5*(C.ClipY-PortraitHeight) + 0.025*PortraitHeight);
		C.DrawTile( Portrait, PortraitWidth, PortraitHeight, 0, 0, 256, 384);

		C.SetPos(-PortraitWidth*PortraitX,0.5*(C.ClipY-PortraitHeight));
		C.Font = GetFontSizeIndex(C,-2);
		PortraitString = PortraitPRI.PlayerName;
		C.StrLen(PortraitString,XL,YL);
		if ( XL > PortraitWidth )
		{
			C.Font = GetFontSizeIndex(C,-4);
			C.StrLen(PortraitString,XL,YL);
			if ( XL > PortraitWidth )
			{
				Abbrev = float(len(PortraitString)) * PortraitWidth/XL;
				PortraitString = left(PortraitString,Abbrev);
				C.StrLen(PortraitString,XL,YL);
			}
		}

		C.DrawColor = C.static.MakeColor(160,160,160);
		C.SetPos(-PortraitWidth*PortraitX + 0.025*PortraitWidth,0.5*(C.ClipY-PortraitHeight) + 0.025*PortraitHeight);
		C.DrawTile( Material'XGameShaders.ModuNoise', PortraitWidth, PortraitHeight, 0.0, 0.0, 512, 512 );

		C.DrawColor = WhiteColor;
		C.SetPos(-PortraitWidth*PortraitX,0.5*(C.ClipY-PortraitHeight));
		C.DrawTileStretched(texture 'InterfaceContent.Menu.BorderBoxA1', 1.05 * PortraitWidth, 1.05*PortraitHeight);

		C.DrawColor = WhiteColor;
		C.SetPos(C.ClipY/256-PortraitWidth*PortraitX + 0.5 * (PortraitWidth - XL),0.5*(C.ClipY+PortraitHeight) + 0.06*PortraitHeight);
		if ( PortraitPRI != None )
		{
			if ( PortraitPRI.Team != None )
			{
				if ( PortraitPRI.Team.TeamIndex == 0 )
					C.DrawColor = RedColor;
				else
					C.DrawColor = TurqColor;
			}
			C.DrawText(PortraitString,true);
		}
	}

    // Screen
    ShowPointBarTop(C);

    if( bShowPersonalInfo )
    {
        DrawSpriteWidget (C, Adrenaline[0]);
        DrawSpriteWidget (C, Adrenaline[3]);
        DrawSpriteWidget (C, Adrenaline[4]);
        DrawNumericWidget (C, AdrenalineCount, DigitsBig);
        DrawSpriteWidget (C, AdrenalineIcon);

		if( PawnOwner.IsA ('XPawn') && (XPawn(PawnOwner).UDamageTime > Level.TimeSeconds) )
		{
			UDamageFill.Scale = FMin((XPawn(PawnOwner).UDamageTime - Level.TimeSeconds) * 0.0333,1);

			DrawSpriteWidget (C, UDamageFill);
			DrawSpriteWidget (C, UDamageTeamTint);
			DrawSpriteWidget (C, UDamageTrim);
		}
        DrawSpriteWidget (C, HealthIcon);

		if( ShieldCount.Value > 0 )
		{
			DrawSpriteWidget (C, ShieldIcon);
			DrawNumericWidget (C, ShieldCount, DigitsBig);
		}

        DrawNumericWidget (C, HealthCount, DigitsBig);
	}

    UpdateRankAndSpread(C);

    if( bShowWeaponInfo && (PawnOwner != None) && (PawnOwner.Weapon != None) )
    {
        DrawNumericWidget (C, AmmoCount, DigitsBig);
        if ( bSmallWeaponBar )
			PawnOwner.Weapon.NewDrawWeaponInfo(C, 0.87*C.ClipX);
		else
			PawnOwner.Weapon.NewDrawWeaponInfo(C, 0.705*C.ClipX);
    }

	if ( (PawnOwner != PlayerOwner.Pawn) && (PawnOwner != None)
		&& (PawnOwner.PlayerReplicationInfo != None) )
	{
		// draw viewed player name
	    C.Font = GetMediumFontFor(C);
        C.SetDrawColor(255,255,0,255);
		C.StrLen(PawnOwner.PlayerReplicationInfo.PlayerName,NameWidth,SmallH);
		NameWidth = FMax(NameWidth, 0.15 * C.ClipX);
		if ( C.ClipX >= 640 )
		{
			C.Font = GetConsoleFont(C);
			C.StrLen("W",XL,SmallH);
			C.SetPos(79*C.ClipX/80 - NameWidth,C.ClipY * 0.68);
			C.DrawText(NowViewing,false);
		}

        C.Font = GetMediumFontFor(C);
        C.SetPos(79*C.ClipX/80 - NameWidth,C.ClipY * 0.68 + SmallH);
        C.DrawText(PawnOwner.PlayerReplicationInfo.PlayerName,false);
	}

    DrawCrosshair(C);
}

simulated function DrawWeaponBar( Canvas C )
{
    local int i;

    local Weapon Weapons[WEAPON_BAR_SIZE];
    local Inventory Inv;
    local Weapon W, PendingWeapon;
	local int Count, WeaponBarPos;
	local float RealHUDScale;
	local float NewPosX,NewPosY, SavedPosY, AddPosX, WidgetWidth, BigWidgetPos;
    local float LeftOffset, RightOffset;

    if (PawnOwner.PendingWeapon != None)
        PendingWeapon = PawnOwner.PendingWeapon;
    else
        PendingWeapon = PawnOwner.Weapon;

	// fill:
    for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
    {
        W = Weapon( Inv );
		Count++;
		if ( Count > 100 )
			break;

        if( W == None )
            continue;

        if( W.IconMaterial == None )
            continue;

		if ( W.InventoryGroup == 0 )
			Weapons[8] = W;
		else if ( W.InventoryGroup < 10 )
			Weapons[W.InventoryGroup-1] = W;
    }
	if ( PendingWeapon != None )
	{
        WeaponBarPos = -1;

		if ( PendingWeapon.InventoryGroup == 0 )
            WeaponBarPos = 8;
		else if ( PendingWeapon.InventoryGroup < 10 )
            WeaponBarPos = PendingWeapon.InventoryGroup - 1;

        if ( WeaponBarPos != -1 )
            Weapons[WeaponBarPos] = PendingWeapon;
	}

	if ( bSmallWeaponBar )
	{
		RealHUDScale = HUDScale;
		HudScale *= 0.67;
		SavedPosY = Default.WeaponBarTint[0].PosY + (1 - HUDScale) * 0.043;
	}

    if ( bSmallWeaponBar && PendingWeapon != none && WeaponBarPos != -1 )
    {
        WidgetWidth = Default.WeaponBarTrim[0].TextureCoords.X2 - Default.WeaponBarTrim[0].TextureCoords.X1 + 1;
        BigWidgetPos = float(WeaponBarPos) / float(WEAPON_BAR_SIZE - 1);
        LeftOffset = (WidgetWidth * 0.33 * (1.0 - BigWidgetPos));
        RightOffset = (WidgetWidth * 0.33 * BigWidgetPos);

        for( i=0; i<WeaponBarPos; i++ )
        {
            WeaponBarAmmoFill[i].OffsetX = Default.WeaponBarAmmoFill[i].OffsetX - LeftOffset;
            WeaponBarTint[i].OffsetX     = Default.WeaponBarTint[i].OffsetX     - LeftOffset;
            WeaponBarTrim[i].OffsetX     = Default.WeaponBarTrim[i].OffsetX     - LeftOffset;
            WeaponBarIcon[i].OffsetX     = Default.WeaponBarIcon[i].OffsetX     - LeftOffset;
        }

        for( i=WeaponBarPos+1; i<WEAPON_BAR_SIZE; i++ )
        {
            WeaponBarAmmoFill[i].OffsetX = Default.WeaponBarAmmoFill[i].OffsetX + RightOffset;
            WeaponBarTint[i].OffsetX     = Default.WeaponBarTint[i].OffsetX     + RightOffset;
            WeaponBarTrim[i].OffsetX     = Default.WeaponBarTrim[i].OffsetX     + RightOffset;
            WeaponBarIcon[i].OffsetX     = Default.WeaponBarIcon[i].OffsetX     + RightOffset;
        }
    }

    // Draw:
    for( i=0; i<WEAPON_BAR_SIZE; i++ )
    {
        W = Weapons[i];

		if ( bSmallWeaponBar )
		{
			if ( W == PendingWeapon )
				HUDScale = RealHUDScale;
			else
				HUDScale = 0.67 * RealHUDScale;
		}

		if ( bUsingCustomHUDColor )
		{
			WeaponBarTint[i].Tints[0] = CustomHUDColor;
			WeaponBarTint[i].Tints[1] = CustomHUDColor;
		}
		else
		{
			WeaponBarTint[i].Tints[0] = default.WeaponBarTint[i].Tints[0];
			WeaponBarTint[i].Tints[1] = default.WeaponBarTint[i].Tints[1];
		}
        if( W == None )
        {
            WeaponBarAmmoFill[i].Scale  = 0;

            WeaponBarIcon[i].Tints[TeamIndex].A = 50;
            WeaponBarIcon[i].Tints[TeamIndex].R = 255;
            WeaponBarIcon[i].Tints[TeamIndex].B = 0;
            WeaponBarIcon[i].Tints[TeamIndex].G = 255;

            WeaponBarIcon[i].WidgetTexture = BaseWeapons[i].default.IconMaterial;
            WeaponBarIcon[i].TextureCoords = BaseWeapons[i].default.IconCoords;
        }
        else
        {
            WeaponBarAmmoFill[i].Scale = W.AmmoStatus();

            WeaponBarIcon[i].WidgetTexture = W.IconMaterial;
            WeaponBarIcon[i].TextureCoords = W.IconCoords;

            if (W == PendingWeapon)
            {
                WeaponBarIcon[i].Tints[TeamIndex].A = 255;
                WeaponBarIcon[i].Tints[TeamIndex].R = 255;
                WeaponBarIcon[i].Tints[TeamIndex].B = 0;
                WeaponBarIcon[i].Tints[TeamIndex].G = 255;

                WeaponBarTint[i].Tints[TeamIndex].A = 50;
                WeaponBarTint[i].Tints[TeamIndex].G = 128;
            }
            else
            {
                WeaponBarIcon[i].Tints[TeamIndex].A = 255;
                WeaponBarIcon[i].Tints[TeamIndex].R = 255;
                WeaponBarIcon[i].Tints[TeamIndex].B = 255;
                WeaponBarIcon[i].Tints[TeamIndex].G = 255;
            }
        }

        DrawSpriteWidget( C, WeaponBarAmmoFill[i] );
        DrawSpriteWidget( C, WeaponBarTint[i] );
        DrawSpriteWidget( C, WeaponBarTrim[i] );
        DrawSpriteWidget( C, WeaponBarIcon[i] );
    }
	if ( bSmallWeaponBar )
		HUDScale = RealHUDScale;
}

simulated function UpdateHud()
{
    if ((PawnOwnerPRI != none) && (PawnOwnerPRI.Team != None))
        TeamIndex = Clamp (PawnOwnerPRI.Team.TeamIndex, 0, 1);
    else
        TeamIndex = 1; // Default to the blue HUD because it's sexier

    // Update values ===============================================================================

    CalculateScore();
    // Score.Value = CurScore;

    CalculateHealth();
    HealthCount.Value = CurHealth;

    HealthIcon.Tints[TeamIndex].R = 255 - ( 255 * ( FClamp( CurHealth / 100, 0.0, 1.0) ));
    HealthIcon.Tints[TeamIndex].G = 0;
    HealthIcon.Tints[TeamIndex].B = 255;

    CalculateShield();
    ShieldCount.Value = CurShield;

    CalculateEnergy();
    AdrenalineReady = (CurEnergy == MaxEnergy);

    CalculateAmmo();
    AmmoCount.Value = CurAmmoPrimary;
    if(!TeamLinked)
    {
        RHud2[3].Tints[TeamIndex].R = 255 - ( 255 * ( FClamp( CurAmmoPrimary / MaxAmmoPrimary, 0.0, 1.0) ));
        RHud2[3].Tints[TeamIndex].G = ( 255 * ( FClamp( CurAmmoPrimary / MaxAmmoPrimary, 0.0, 1.0) ));
        RHud2[3].Tints[TeamIndex].B = 0;
    }
    Super.UpdateHud ();
}

function bool DrawLevelAction (Canvas C)
{
    local String LevelActionText;
    local Plane OldModulate;

    if ((Level.LevelAction == LEVACT_None) && (Level.Pauser != none))
    {
        LevelActionText = LevelActionPaused;
    }
    else if ((Level.LevelAction == LEVACT_Loading) || (Level.LevelAction == LEVACT_Precaching))
        LevelActionText = LevelActionLoading;
    else
        LevelActionText = "";

    if (LevelActionText == "")
        return (false);

    C.Font = LoadLevelActionFont();
    C.DrawColor = LevelActionFontColor;
    C.Style = ERenderStyle.STY_Alpha;

    OldModulate = C.ColorModulate;
    C.ColorModulate = C.default.ColorModulate;

    C.DrawScreenText (LevelActionText, LevelActionPositionX, LevelActionPositionY, DP_MiddleMiddle);

    C.ColorModulate = OldModulate;

    return (true);
}

function DisplayPortrait(PlayerReplicationInfo PRI)
{
	local Material NewPortrait;

    if ( LastPlayerIDTalking > 0 )
    	return;

	NewPortrait = PRI.GetPortrait();
	if ( NewPortrait == None )
		return;
	if ( Portrait == None )
		PortraitX = 1;
	Portrait = NewPortrait;
	PortraitTime = Level.TimeSeconds + 3;
	PortraitPRI = PRI;
}

simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
	Super.Message(PRI,Msg,MsgType);
    if ( PRI != None && (MsgType == 'Say') || (MsgType == 'TeamSay') )
        DisplayPortrait(PRI);
}

simulated function font LoadLevelActionFont()
{
	if( LevelActionFontFont == None )
	{
		LevelActionFontFont = Font(DynamicLoadObject(LevelActionFontName, class'Font'));
		if( LevelActionFontFont == None )
			Log("Warning: "$Self$" Couldn't dynamically load font "$LevelActionFontName);
	}
	return LevelActionFontFont;
}

defaultproperties
{
	bSmallWeaponBar=true
    ReloadingTrim=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=450,Y1=415,X1=836,Y2=453),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=-137,OffsetY=15,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    ReloadingTeamTint=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=450,Y1=454,X1=836,Y2=490),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=-137,OffsetY=15,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    ReloadingFill=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=450,Y1=454,X1=836,Y2=490),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=-137,OffsetY=15,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))

    UDamageTrim=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=450,Y1=453,X1=836,Y2=415),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=137,OffsetY=15,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    UDamageTeamTint=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=450,Y1=490,X1=836,Y2=454),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=137,OffsetY=15,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    UDamageFill=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=450,Y1=490,X1=836,Y2=454),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=137,OffsetY=15,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=255,A=255),Tints[1]=(R=255,G=0,B=255,A=255))

    // Digits
    DigitsBig=(DigitTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords[0]=(X1=100,Y1=400,X2=199,Y2=499),TextureCoords[1]=(X1=0,Y1=0,X2=99,Y2=99),TextureCoords[2]=(X1=100,Y1=0,X2=199,Y2=99),TextureCoords[3]=(X1=0,Y1=100,X2=99,Y2=199),TextureCoords[4]=(X1=100,Y1=100,X2=199,Y2=199),TextureCoords[5]=(X1=0,Y1=200,X2=99,Y2=299),TextureCoords[6]=(X1=100,Y1=200,X2=199,Y2=299),TextureCoords[7]=(X1=0,Y1=300,X2=99,Y2=399),TextureCoords[8]=(X1=100,Y1=300,X2=199,Y2=399),TextureCoords[9]=(X1=0,Y1=400,X2=99,Y2=499),TextureCoords[10]=(X1=200,Y1=0,X2=299,Y2=99)))//(X1=100,Y1=400,X2=199,Y2=499)))

    // HUD ELEMENTS -left
    LHud1[0]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=763,X2=298,Y2=1023),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=0,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255)) // -- Hud Border
    LHud1[1]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=299,Y1=763,X2=454,Y2=1023),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=0,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50)) // -- Hud Color
    LHud1[2]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=455,Y1=763,X2=610,Y2=1023),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=0,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50)) // -- Hud Fill
    LHud1[3]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=0,Y1=880,X2=142,Y2=1023),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=85,OffsetY=50,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255)) // -- Hud Cirlce

    LHud2[0]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=611,Y1=900,X2=979,Y2=1023),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=180,OffsetY=60,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    LHud2[1]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=611,Y1=777,X2=979,Y2=899),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=180,OffsetY=60,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    LHud2[2]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=611,Y1=654,X2=979,Y2=776),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=180,OffsetY=60,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    LHud2[3]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=810,Y1=200,X2=1023,Y2=413),TextureScale=0.25,DrawPivot=DP_UpperLeft,PosX=0.0,PosY=0.835,OffsetX=90,OffsetY=35,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=100),Tints[1]=(R=255,G=255,B=0,A=100))

    // - right
    RHud1[0]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=143,Y1=763,X1=298,Y2=1023),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=0,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    RHud1[1]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=299,Y1=763,X1=454,Y2=1023),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=0,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    RHud1[2]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=455,Y1=763,X1=610,Y2=1023),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=0,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    RHud1[3]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=0,Y1=880,X1=142,Y2=1023),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=-85,OffsetY=50,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))

    RHud2[0]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=611,Y1=900,X1=979,Y2=1023),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=-180,OffsetY=60,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    RHud2[1]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=611,Y1=777,X1=979,Y2=899),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=-180,OffsetY=60,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    RHud2[2]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=611,Y1=654,X1=979,Y2=776),TextureScale=0.3,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=-180,OffsetY=60,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    RHud2[3]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=810,Y1=200,X2=1023,Y2=413),TextureScale=0.25,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0.835,OffsetX=-68,OffsetY=37,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))

    // Adrenaline
    Adrenaline[0]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=611,Y1=900,X1=979,Y2=1023),TextureScale=0.23,DrawPivot=DP_UpperRight,PosX=1,PosY=0,OffsetX=-95,OffsetY=10,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    Adrenaline[1]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=611,Y1=777,X1=979,Y2=899),TextureScale=0.23,DrawPivot=DP_UpperRight,PosX=1,PosY=0,OffsetX=-95,OffsetY=10,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    Adrenaline[2]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X2=611,Y1=654,X1=979,Y2=776),TextureScale=0.23,DrawPivot=DP_UpperRight,PosX=1,PosY=0,OffsetX=-95,OffsetY=10,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    Adrenaline[3]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=0,Y1=880,X2=142,Y2=1023),TextureScale=0.23,DrawPivot=DP_UpperRight,PosX=1,PosY=0,OffsetX=0,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    Adrenaline[4]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=810,Y1=200,X2=1023,Y2=413),TextureScale=0.2,DrawPivot=DP_UpperRight,PosX=1,PosY=0,OffsetX=35,OffsetY=-28,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=0),Tints[1]=(R=255,G=255,B=0,A=0))

    ScoreBg[0]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=611,Y1=900,X2=979,Y2=1023),TextureScale=0.23,DrawPivot=DP_UpperLeft,PosX=0,PosY=0,OffsetX=95,OffsetY=10,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    ScoreBg[1]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=611,Y1=777,X2=979,Y2=899),TextureScale=0.23,DrawPivot=DP_UpperLeft,PosX=0,PosY=0,OffsetX=95,OffsetY=10,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    ScoreBg[2]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=611,Y1=654,X2=979,Y2=776),TextureScale=0.23,DrawPivot=DP_UpperLeft,PosX=0,PosY=0,OffsetX=95,OffsetY=10,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    ScoreBg[3]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=0,Y1=880,X2=142,Y2=1023),TextureScale=0.23,DrawPivot=DP_UpperLeft,PosX=0,PosY=0,OffsetX=0,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))

    // Icons
    HealthIcon=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=0,Y1=750,X2=142,Y2=879),TextureScale=0.3,DrawPivot=DP_UpperLeft,PosX=0,PosY=0.835,OffsetX=82,OffsetY=55,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=0,G=0,B=255,A=255),Tints[1]=(R=0,G=0,B=255,A=255))
    ShieldIcon=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=458,Y1=584,X2=583,Y2=749),TextureScale=0.25,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.835,OffsetX=0,OffsetY=130,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    ShieldIconGlow=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=333,Y1=584,X2=457,Y2=749),TextureScale=0.26,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.835,OffsetX=-1,OffsetY=125,ScaleMode=SM_Left,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    AdrenalineIcon=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=0,Y1=620,X2=142,Y2=749),TextureScale=0.23,DrawPivot=DP_UpperRight,PosX=1,PosY=0,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))

    Crosshairs[0]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Cross1',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.75,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[1]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Cross2',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.75,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[2]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Cross3',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.75,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[3]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Cross4',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.75,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[4]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Cross5',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.75,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[5]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Dot',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.75,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[6]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Pointer',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.6,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[7]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Triad1',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.7,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[8]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Triad2',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.7,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[9]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Triad3',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.7,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[10]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Bracket1',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.6,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[11]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Bracket2',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.6,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[12]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Circle1',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.4,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    Crosshairs[13]=(WidgetTexture=Material'Crosshairs.Hud.Crosshair_Circle2',TextureCoords=(X1=0,Y1=0,X2=64,Y2=64),TextureScale=0.4,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.5,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))

    AdrenalineCount=(TextureScale=0.18,DrawPivot=DP_UpperRight,PosX=1.0,PosY=0,OffsetX=-260,OffsetY=40,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    myScore=(TextureScale=0.18,MinDigitCount=2,DrawPivot=DP_UpperRight,PosX=0,PosY=0,OffsetX=560,OffsetY=40,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    mySpread=(TextureScale=0.09,MinDigitCount=2,DrawPivot=DP_UpperRight,PosX=0,PosY=0,OffsetX=655,OffsetY=135,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    myRank=(TextureScale=0.15,MinDigitCount=2,DrawPivot=DP_UpperRight,PosX=0,PosY=0,OffsetX=150,OffsetY=40,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))

    HealthCount=(TextureScale=0.25,DrawPivot=DP_MiddleRight,PosX=0,PosY=0.835,OffsetX=620,OffsetY=145,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    ShieldCount=(TextureScale=0.25,DrawPivot=DP_MiddleMiddle,PosX=0.5,PosY=0.835,OffsetX=0,OffsetY=145,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))
    AmmoCount=(TextureScale=0.25,DrawPivot=DP_UpperRight,PosX=1,PosY=0.835,OffsetX=-340,OffsetY=95,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))

    // Tint, TeamColor, Fill display for Weapons
    WeaponBarAmmoFill[0]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=741,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerLeft,PosX=0.5,PosY=1.0,OffsetX=-855,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=200),Tints[1]=(R=255,G=255,B=0,A=200))
    WeaponBarAmmoFill[1]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=741,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerLeft,PosX=0.5,PosY=1.0,OffsetX=-665,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=200),Tints[1]=(R=255,G=255,B=0,A=200))
    WeaponBarAmmoFill[2]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=741,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerLeft,PosX=0.5,PosY=1.0,OffsetX=-475,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=200),Tints[1]=(R=255,G=255,B=0,A=200))
    WeaponBarAmmoFill[3]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=741,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerLeft,PosX=0.5,PosY=1.0,OffsetX=-285,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=200),Tints[1]=(R=255,G=255,B=0,A=200))
    WeaponBarAmmoFill[4]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=741,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerLeft,PosX=0.5,PosY=1.0,OffsetX=-95,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=200),Tints[1]=(R=255,G=255,B=0,A=200))
    WeaponBarAmmoFill[5]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=741,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerLeft,PosX=0.5,PosY=1.0,OffsetX=95,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=200),Tints[1]=(R=255,G=255,B=0,A=200))
    WeaponBarAmmoFill[6]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=741,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerLeft,PosX=0.5,PosY=1.0,OffsetX=285,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=200),Tints[1]=(R=255,G=255,B=0,A=200))
    WeaponBarAmmoFill[7]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=741,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerLeft,PosX=0.5,PosY=1.0,OffsetX=475,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=200),Tints[1]=(R=255,G=255,B=0,A=200))
    WeaponBarAmmoFill[8]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=741,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerLeft,PosX=0.5,PosY=1.0,OffsetX=665,OffsetY=0,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=200),Tints[1]=(R=255,G=255,B=0,A=200))

    WeaponBarTint[0]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=678,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=-760,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    WeaponBarTint[1]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=678,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=-570,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    WeaponBarTint[2]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=678,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=-380,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    WeaponBarTint[3]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=678,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=-190,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    WeaponBarTint[4]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=678,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    WeaponBarTint[5]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=678,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=190,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    WeaponBarTint[6]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=678,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=380,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    WeaponBarTint[7]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=678,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=570,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))
    WeaponBarTint[8]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=678,X2=332,Y2=749),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=760,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=0,B=0,A=50),Tints[1]=(R=0,G=64,B=255,A=50))

    WeaponBarTrim[0]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=533,X2=332,Y2=605),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=-760,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    WeaponBarTrim[1]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=533,X2=332,Y2=605),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=-570,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    WeaponBarTrim[2]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=533,X2=332,Y2=605),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=-380,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    WeaponBarTrim[3]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=533,X2=332,Y2=605),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=-190,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    WeaponBarTrim[4]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=533,X2=332,Y2=605),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=0,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    WeaponBarTrim[5]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=533,X2=332,Y2=605),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=190,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    WeaponBarTrim[6]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=533,X2=332,Y2=605),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=380,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    WeaponBarTrim[7]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=533,X2=332,Y2=605),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=570,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))
    WeaponBarTrim[8]=(WidgetTexture=Material'InterfaceContent.Hud.SkinA',TextureCoords=(X1=143,Y1=533,X2=332,Y2=605),TextureScale=0.3,DrawPivot=DP_LowerMiddle,PosX=0.5,PosY=1.0,OffsetX=760,OffsetY=0,ScaleMode=SM_None,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=0,A=255),Tints[1]=(R=255,G=255,B=0,A=255))

	WeaponBarIcon(0)=(DrawPivot=DP_LowerMiddle,RenderStyle=STY_Alpha,TextureCoords=(X1=169,Y1=39,X2=241,Y2=77),TextureScale=0.53,PosX=0.5,PosY=1.0,OffsetX=-742,OffsetY=0,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(G=255,R=255,B=255,A=255),Tints[1]=(G=255,R=255,B=255,A=255))
	WeaponBarIcon(1)=(DrawPivot=DP_LowerMiddle,RenderStyle=STY_Alpha,TextureCoords=(X1=245,Y1=39,X2=329,Y2=79),TextureScale=0.53,PosX=0.5,PosY=1.0,OffsetX=-552,OffsetY=0,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(G=255,R=255,B=255,A=255),Tints[1]=(G=255,R=255,B=255,A=255))
	WeaponBarIcon(2)=(DrawPivot=DP_LowerMiddle,RenderStyle=STY_Alpha,TextureCoords=(X1=179,Y1=127,X2=241,Y2=175),TextureScale=0.53,PosX=0.5,PosY=1.0,OffsetX=-362,OffsetY=0,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(G=255,R=255,B=255,A=255),Tints[1]=(G=255,R=255,B=255,A=255))
	WeaponBarIcon(3)=(DrawPivot=DP_LowerMiddle,RenderStyle=STY_Alpha,TextureCoords=(X1=250,Y1=110,X2=330,Y2=145),TextureScale=0.53,PosX=0.5,PosY=1.0,OffsetX=-172,OffsetY=0,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(G=255,R=255,B=255,A=255),Tints[1]=(G=255,R=255,B=255,A=255))
	WeaponBarIcon(4)=(DrawPivot=DP_LowerMiddle,RenderStyle=STY_Alpha,TextureCoords=(X1=169,Y1=78,X2=244,Y2=124),TextureScale=0.53,PosX=0.5,PosY=1.0,OffsetX=18,OffsetY=0,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(G=255,R=255,B=255,A=255),Tints[1]=(G=255,R=255,B=255,A=255))
	WeaponBarIcon(5)=(DrawPivot=DP_LowerMiddle,RenderStyle=STY_Alpha,TextureCoords=(X1=246,Y1=80,X2=332,Y2=106),TextureScale=0.53,PosX=0.5,PosY=1.0,OffsetX=208,OffsetY=0,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(G=255,R=255,B=255,A=255),Tints[1]=(G=255,R=255,B=255,A=255))
	WeaponBarIcon(6)=(DrawPivot=DP_LowerMiddle,RenderStyle=STY_Alpha,TextureCoords=(X1=169,Y1=172,X2=245,Y2=208),TextureScale=0.53,PosX=0.5,PosY=1.0,OffsetX=398,OffsetY=0,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(G=255,R=255,B=255,A=255),Tints[1]=(G=255,R=255,B=255,A=255))
	WeaponBarIcon(7)=(DrawPivot=DP_LowerMiddle,RenderStyle=STY_Alpha,TextureCoords=(X1=253,Y1=146,X2=333,Y2=181),TextureScale=0.53,PosX=0.5,PosY=1.0,OffsetX=588,OffsetY=0,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(G=255,R=255,B=255,A=255),Tints[1]=(G=255,R=255,B=255,A=255))
	WeaponBarIcon(8)=(DrawPivot=DP_LowerMiddle,RenderStyle=STY_Alpha,TextureCoords=(X1=246,Y1=182,X2=331,Y2=210),TextureScale=0.53,PosX=0.5,PosY=1.0,OffsetX=778,OffsetY=0,ScaleMode=SM_Right,Scale=1.000000,Tints[0]=(G=255,R=255,B=255,A=255),Tints[1]=(G=255,R=255,B=255,A=255))

    AmmoIcon=(TextureScale=0.45,DrawPivot=DP_UpperLeft,PosX=1.0,PosY=0.835,OffsetX=-151,OffsetY=44,ScaleMode=SM_Right,Scale=1.0,RenderStyle=STY_Alpha,Tints[0]=(R=255,G=255,B=255,A=255),Tints[1]=(R=255,G=255,B=255,A=255))

    BaseWeapons[0]=class'ShieldGun'
    BaseWeapons[1]=class'AssaultRifle'
    BaseWeapons[2]=class'BioRifle'
    BaseWeapons[3]=class'ShockRifle'
    BaseWeapons[4]=class'LinkGun'
    BaseWeapons[5]=class'MiniGun'
    BaseWeapons[6]=class'FlakCannon'
    BaseWeapons[7]=class'RocketLauncher'
    BaseWeapons[8]=class'SniperRifle'

    LevelActionFontColor=(R=255,G=255,B=255,A=255)

    CurrentWeaponPositionX=0.845
    CurrentWeaponPositionY=0.9

    LevelActionPositionX=0.5
    LevelActionPositionY=0.25

    ConsoleMessagePosX=0.005
    ConsoleMessagePosY=0.825

    LogoTexture=Material'InterfaceContent.Logos.Logo'
    LogoScaleX=0.25
    LogoScaleY=0.25
    LogoPosX=0.49
    LogoPosY=0.15

	CountDown(0)=sound'AnnouncerMale2K4.One'
	CountDown(1)=sound'AnnouncerMale2K4.Two'
	CountDown(2)=sound'AnnouncerMale2K4.Three'
	CountDown(3)=sound'AnnouncerMale2K4.Four'
	CountDown(4)=sound'AnnouncerMale2K4.Five'
	CountDown(5)=sound'AnnouncerMale2K4.Six'
	CountDown(6)=sound'AnnouncerMale2K4.Seven'
	CountDown(7)=sound'AnnouncerMale2K4.Eight'
	CountDown(8)=sound'AnnouncerMale2K4.Nine'
	CountDown(9)=sound'AnnouncerMale2K4.Ten'

	LongCount(0)=sound'AnnouncerMale2K4.5_minute_warning'
	LongCount(1)=sound'AnnouncerMale2K4.3_minutes_remain'
	LongCount(2)=sound'AnnouncerMale2K4.2_minutes_remain'
	LongCount(3)=sound'AnnouncerMale2K4.1_minute_remains'
	LongCount(4)=sound'AnnouncerMale2K4.30_seconds_remain'
	LongCount(5)=sound'AnnouncerMale2K4.20_seconds'

	OldHUDScale=1.0
	bUseCustomWeaponCrosshairs=true
}
